/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.server.VWEnvironmentData;
import filenet.vw.server.VWEnvironmentDataQueryResults;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

final class VWEnvironmentDataList
implements Serializable {
    private static final long serialVersionUID = 472L;
    protected int bufferSize = 200;
    protected Collection fetchedObjects = null;
    protected int returnCount = 0;
    protected int fetchCount = 0;
    protected boolean queryIsOver = false;
    protected VWEnvironmentData lastRecord = null;
    protected VWSession session = null;
    protected Map allUserRecords = null;
    protected VWEnvironmentDataQueryResults qresult = null;
    protected boolean throwException = true;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-02-18 22:59:41 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/1 $";
    }

    protected VWEnvironmentDataList(VWSession theSession, int theBufferSize, boolean bThrowException) throws VWException {
        this.session = theSession;
        if (theBufferSize > 0) {
            this.bufferSize = theBufferSize;
        }
        this.throwException = bThrowException;
        this.hasNext();
    }

    protected void resetFetch() {
        this.queryIsOver = false;
        this.lastRecord = null;
        this.fetchedObjects = null;
        this.returnCount = 0;
        this.fetchCount = 0;
    }

    protected Object next() throws VWException {
        Object result = null;
        if (this.fetchCount == this.returnCount) {
            this.dofetch();
        }
        if (this.fetchCount != 0) {
            result = this.fetchedObjects.iterator().next();
            ++this.returnCount;
        }
        return result;
    }

    protected void dofetch() throws VWException {
        if (this.fetchCount == this.returnCount) {
            this.returnCount = 0;
            this.fetchCount = 0;
            if (!this.queryIsOver) {
                this.session.checkSession();
                this.qresult = this.session.getCmdSession().fetchUserEnvironmentRecords(this.bufferSize, this.lastRecord, this.throwException);
                if (this.qresult != null) {
                    this.fetchedObjects = this.qresult.envDataTable.values();
                    this.lastRecord = this.qresult.lastRecord;
                    this.queryIsOver = this.qresult.queryIsOver;
                }
            }
            if (this.fetchedObjects != null) {
                this.fetchCount = this.fetchedObjects.size();
            }
        }
    }

    protected boolean hasNext() throws VWException {
        boolean result = true;
        if (this.fetchCount == 0) {
            this.dofetch();
        }
        result = this.fetchedObjects.iterator().hasNext();
        return result;
    }

    protected Map getAllUserInfoRecords() throws VWException {
        this.allUserRecords = null;
        this.allUserRecords = new TreeMap();
        this.resetFetch();
        boolean cnt = false;
        while (!this.queryIsOver) {
            this.returnCount = this.fetchCount;
            this.dofetch();
            this.allUserRecords.putAll(this.qresult.envDataTable);
        }
        return this.allUserRecords;
    }

    protected String toCharString() {
        String theString = "";
        theString = this.fetchedObjects.toString();
        return theString;
    }
}

